<?php
require_once __DIR__.'/../includes/db.php';
require_once __DIR__.'/../includes/email.php';

if($_SERVER['REQUEST_METHOD']==='POST'){
    $email=$_POST['email'];
    $stmt=$pdo->prepare("SELECT id,verify_token,is_verified FROM users WHERE email=? LIMIT 1");
    $stmt->execute([$email]);
    $u=$stmt->fetch();

    if(!$u) exit("No account found.");

    if((int)$u['is_verified']===1) exit("Already verified.");

    $token=$u['verify_token'] ?: bin2hex(random_bytes(32));
    $pdo->prepare("UPDATE users SET verify_token=? WHERE id=?")->execute([$token,$u['id']]);

    $url="https://".$_SERVER['HTTP_HOST']."/verify.php?token=".$token;

    send_email($email,"Resend Verification","Verify: $url","<a href='$url'>Verify</a>");

    exit("Verification email sent.");
}
echo "<form method=post><input name=email placeholder='Email'><button>Resend Verification</button></form>";
