<?php
// public/register.php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email     = trim($_POST['email'] ?? '');
    $password  = $_POST['password'] ?? '';
    $full_name = trim($_POST['full_name'] ?? '');

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        set_flash('error', 'Please enter a valid email address.');
    } elseif (strlen($password) < 8) {
        set_flash('error', 'Password must be at least 8 characters.');
    } else {
        // Check if email exists
        $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ? LIMIT 1');
        $stmt->execute([$email]);
        if ($stmt->fetch()) {
            set_flash('error', 'An account with that email already exists.');
        } else {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare('INSERT INTO users (email, password_hash, full_name, role) VALUES (?, ?, ?, ?)');
            $stmt->execute([$email, $hash, $full_name, 'user']);

            set_flash('success', 'Account created. You can now log in.');
            redirect('login.php');
        }
    }
}
?>

<div class="auth-card">
    <h1>Create your account</h1>
    <form method="post" action="">
        <div class="form-group">
            <label for="full_name">Full name (optional)</label>
            <input type="text" id="full_name" name="full_name" value="<?= htmlspecialchars($_POST['full_name'] ?? '') ?>">
        </div>

        <div class="form-group">
            <label for="email">Email address</label>
            <input type="email" id="email" name="email" required value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
        </div>

        <div class="form-group">
            <label for="password">Password (min 8 characters)</label>
            <input type="password" id="password" name="password" required>
        </div>

        <button type="submit" class="btn">Create account</button>
    </form>
    <p style="margin-top:0.75rem;font-size:0.85rem;color:#9ca3af;">
        Already have an account? <a href="login.php">Log in</a>
    </p>
</div>

<?php
require_once __DIR__ . '/../includes/footer.php';
