<?php
// public/login.php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/header.php';

if (is_logged_in()) {
    redirect('dashboard.php');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    $stmt = $pdo->prepare('SELECT id, password_hash, role FROM users WHERE email = ? LIMIT 1');
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if (!$user || !password_verify($password, $user['password_hash'])) {
        set_flash('error', 'Invalid email or password.');
    } else {
        $_SESSION['user_id']   = (int)$user['id'];
        $_SESSION['user_role'] = $user['role'];
        set_flash('success', 'Welcome back!');
        redirect('dashboard.php');
    }
}
?>

<div class="auth-card">
    <h1>Log in</h1>
    <form method="post" action="">
        <div class="form-group">
            <label for="email">Email address</label>
            <input type="email" id="email" name="email" required value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" required>
        </div>

        <button type="submit" class="btn">Log in</button>
    </form>
    <p style="margin-top:0.75rem;font-size:0.85rem;color:#9ca3af;">
        Don’t have an account yet? <a href="register.php">Create one</a>
    </p>
</div>

<?php
require_once __DIR__ . '/../includes/footer.php';
