<?php
// includes/header.php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/functions.php';
$flashes = get_flashes();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars(APP_NAME) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
<header class="site-header">
    <div class="container header-inner">
        <div class="logo">
            <a href="index.php"><?= htmlspecialchars(APP_NAME) ?></a>
        </div>
        <nav class="nav">
            <?php if (is_logged_in()): ?>
                <a href="dashboard.php">Dashboard</a>
                <a href="logout.php">Logout</a>
            <?php else: ?>
                <a href="login.php">Login</a>
                <a href="register.php" class="btn-primary">Get Started</a>
            <?php endif; ?>
        </nav>
    </div>
</header>

<main class="site-main container">
    <?php if (!empty($flashes)): ?>
        <div class="flash-wrapper">
            <?php foreach ($flashes as $type => $messages): ?>
                <?php foreach ($messages as $msg): ?>
                    <div class="flash flash-<?= htmlspecialchars($type) ?>">
                        <?= htmlspecialchars($msg) ?>
                    </div>
                <?php endforeach; ?>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
