<?php
// includes/auth.php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/functions.php';

function require_login()
{
    if (!is_logged_in()) {
        set_flash('error', 'Please log in to access that page.');
        redirect('login.php');
    }
}

function require_admin()
{
    if (!is_logged_in() || current_user_role() !== 'admin') {
        set_flash('error', 'You do not have permission to access that page.');
        redirect('dashboard.php');
    }
}
