<?php
require_once __DIR__ . '/../../includes/auth.php'; 
require_admin();
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/email.php';

$id = $_GET['id'];
$stmt = $pdo->prepare("SELECT r.*, u.email, s.name AS site_name FROM removal_requests r JOIN users u ON r.user_id = u.id JOIN sites s ON r.site_id = s.id WHERE r.id = ? LIMIT 1");
$stmt->execute([$id]);
$r = $stmt->fetch();

if (!$r) {
    echo "Not found";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_status = $_POST['status'] ?? $r['status'];
    $new_notes  = $_POST['notes'] ?? $r['notes'];

    $pdo->prepare("UPDATE removal_requests SET status = ?, notes = ? WHERE id = ?")
        ->execute([$new_status, $new_notes, $id]);

    // Send email to user about status update
    $statusLabel = ucfirst($new_status);
    $user_email = $r['email'];
    $site_name  = $r['site_name'];

    if ($user_email) {
        $subjectU = "Your data removal request was updated";
        $plainU = "Hi,\n\nYour data removal request for {$site_name} was updated to: {$statusLabel}.\n\nThank you,\nPrivacyCleanr Support";
        $htmlU  = "<p>Hi,</p>";
        $htmlU .= "<p>Your data removal request for <strong>" . htmlspecialchars($site_name) . "</strong> was updated to: <strong>" . htmlspecialchars($statusLabel) . "</strong>.</p>";
        $htmlU .= "<p>Thank you,<br>PrivacyCleanr Support</p>";

        send_email($user_email, $subjectU, $plainU, $htmlU);
    }

    header("Location: requests.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Request Details</title>
<link rel="stylesheet" href="https://data.myaihub.xyz/assets/css/style.css">
<style>
body{display:flex;background:#0f172a;color:white;font-family:sans-serif;margin:0}
.sidebar{width:240px;background:#1e293b;height:100vh;padding:1.5rem;position:fixed;left:0;top:0;border-right:1px solid #334155}
.sidebar a{display:block;padding:.8rem 1rem;background:#0f172a;margin-bottom:.5rem;border:1px solid #334155;border-radius:.5rem;text-decoration:none;color:white}
.sidebar a:hover{background:#1e293b}
.main{margin-left:260px;padding:2rem;width:100%}
.auth-card{background:#1e293b;border:1px solid #334155;padding:2rem;border-radius:1rem;max-width:600px}
.form-group{margin-bottom:1rem}
label{display:block;margin-bottom:.5rem}
textarea,select{width:100%;padding:.7rem;background:#0f172a;border:1px solid #334155;color:white;border-radius:.5rem}
.btn{padding:.8rem 1rem;background:#0f172a;border:1px solid #334155;border-radius:.5rem;color:white;cursor:pointer}
.btn:hover{background:#1e293b}
</style>
</head>
<body>
<div class="sidebar">
<h2>Admin Panel</h2>
<a href="dashboard.php">📊 Dashboard</a>
<a href="users.php">👤 Manage Users</a>
<a href="sites.php">🌐 Manage Sites</a>
<a href="requests.php">📨 Manage Requests</a>
<a href="../logout.php">🚪 Logout</a>
</div>
<div class="main">
<h1>Request Details</h1>
<div class="auth-card">
<p><strong>User Email:</strong> <?= htmlspecialchars($r['email']) ?></p>
<p><strong>Site:</strong> <?= htmlspecialchars($r['site_name']) ?></p>
<p><strong>Date:</strong> <?= $r['created_at'] ?></p>
<form method="post">
<div class="form-group">
<label>Status</label>
<select name="status">
<?php foreach(["pending","submitted","in_review","completed","rejected"] as $s): ?>
<option value="<?= $s ?>" <?= $r['status']===$s ? "selected" : "" ?>><?= ucfirst($s) ?></option>
<?php endforeach; ?>
</select>
</div>
<div class="form-group">
<label>Notes</label>
<textarea name="notes" rows="5"><?= htmlspecialchars($r['notes']) ?></textarea>
</div>
<button class="btn" type="submit">Save Changes</button>
</form>
</div>
</div>
</body>
</html>
