<?php
// Simple email helper for PrivacyCleanr / Data Removal SaaS.
// Uses PHP's built-in mail() so it works on shared hosting.
// You can later swap this to PHPMailer or a real SMTP library if needed.

function app_admin_email() {
    // TODO: change this to your real admin inbox
    return "admin@yourdomain.com";
}

function app_from_email() {
    // TODO: change this to the FROM email you want shown
    return "PrivacyCleanr <noreply@yourdomain.com>";
}

/**
 * Send an email (plain + optional HTML) using mail().
 *
 * @param string $to
 * @param string $subject
 * @param string $message_plain
 * @param string|null $message_html
 * @return bool
 */
function send_email($to, $subject, $message_plain, $message_html = null) {
    $boundary = md5(uniqid(time(), true));

    $headers  = "From: " . app_from_email() . "\r\n";
    $headers .= "MIME-Version: 1.0\r\n";

    if ($message_html) {
        // Multipart (plain + HTML)
        $headers .= "Content-Type: multipart/alternative; boundary=\"$boundary\"\r\n";

        $body  = "--$boundary\r\n";
        $body .= "Content-Type: text/plain; charset=UTF-8\r\n\r\n";
        $body .= $message_plain . "\r\n\r\n";

        $body .= "--$boundary\r\n";
        $body .= "Content-Type: text/html; charset=UTF-8\r\n\r\n";
        $body .= $message_html . "\r\n\r\n";

        $body .= "--$boundary--";
    } else {
        // Plain only
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $body = $message_plain;
    }

    return mail($to, '=?UTF-8?B?' . base64_encode($subject) . '?=', $body, $headers);
}
?>
