<?php
require_once __DIR__ . '/../includes/auth.php';
require_login();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$user_id = $_SESSION['user_id'];

// Load sites for dropdown
$sites = $pdo->query("SELECT id, name FROM sites ORDER BY name")->fetchAll();

if($_SERVER['REQUEST_METHOD']==='POST'){
    $site_id = (int)($_POST['site_id'] ?? 0);
    $notes = trim($_POST['notes'] ?? '');
    if($site_id){
        $stmt = $pdo->prepare("INSERT INTO removal_requests (user_id, site_id, status, notes) VALUES (?,?, 'pending', ?)");
        $stmt->execute([$user_id, $site_id, $notes ?: null]);
        set_flash('success', 'Your removal request has been submitted.');
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Please select a site.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>New Removal Request</title>
    <link rel="stylesheet" href="/assets/css/style.css">
    <style>
        body { background:#020617; color:white; font-family:sans-serif; margin:0; }
        .shell { max-width:700px; margin:0 auto; padding:2rem 1.5rem 3rem; }
        .page-header { display:flex; justify-content:space-between; align-items:center; margin-bottom:1.5rem; }
        .page-header h1 { font-size:1.6rem; margin:0; }
        .link-back { color:#9ca3af; text-decoration:none; font-size:.9rem; }
        .link-back:hover { color:white; }
        .card { background:#020617; border:1px solid #1e293b; border-radius:1rem; padding:1.5rem 1.6rem; }
        .form-group { margin-bottom:1rem; }
        .form-group label { display:block; margin-bottom:.4rem; font-size:.9rem; color:#e5e7eb; }
        select, textarea {
            width:100%; padding:.7rem; background:#020617; border:1px solid #1e293b;
            color:white; border-radius:.6rem; font-size:.9rem;
        }
        textarea { min-height:130px; resize:vertical; }
        .hint { font-size:.8rem; color:#9ca3af; margin-top:.25rem; }
        .btn-primary { padding:.8rem 1.1rem; background:#0f172a; border:1px solid #334155; border-radius:.6rem; color:white; cursor:pointer; }
        .btn-primary:hover { background:#1e293b; }
        .flash-error { background:#450a0a; border:1px solid #7f1d1d; padding:.7rem .9rem; border-radius:.5rem; margin-bottom:1rem; font-size:.9rem; }
    </style>
</head>
<body>
<div class="shell">
    <div class="page-header">
        <h1>New Removal Request</h1>
        <a href="dashboard.php" class="link-back">← Back to dashboard</a>
    </div>

    <div class="card">
        <?php if(!empty($error)): ?>
            <div class="flash-error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="form-group">
                <label for="site_id">Select Website / Data Broker</label>
                <select name="site_id" id="site_id" required>
                    <option value="">-- Choose a site --</option>
                    <?php foreach($sites as $s): ?>
                        <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['name']) ?></option>
                    <?php endforeach; ?>
                </select>
                <div class="hint">These are the people-search or leak sites we currently support.</div>
            </div>

            <div class="form-group">
                <label for="notes">Extra Details (optional)</label>
                <textarea name="notes" id="notes" placeholder="Paste any profile URLs, screenshots, or details that help us find and remove your data."></textarea>
                <div class="hint">Do not paste full SSN, full card numbers, or full account logins here.</div>
            </div>

            <button class="btn-primary" type="submit">Submit Request</button>
        </form>
    </div>
</div>
</body>
</html>
