<?php
require_once __DIR__ . '/../includes/auth.php';
require_login();
require_once __DIR__ . '/../includes/db.php';

$user_id = $_SESSION['user_id'];

// Stats
$total_requests = $pdo->prepare("SELECT COUNT(*) FROM removal_requests WHERE user_id = ?");
$total_requests->execute([$user_id]);
$total_requests = $total_requests->fetchColumn();

$pending_requests = $pdo->prepare("SELECT COUNT(*) FROM removal_requests WHERE user_id = ? AND status IN ('pending','submitted','in_review')");
$pending_requests->execute([$user_id]);
$pending_requests = $pending_requests->fetchColumn();

$completed_requests = $pdo->prepare("SELECT COUNT(*) FROM removal_requests WHERE user_id = ? AND status = 'completed'");
$completed_requests->execute([$user_id]);
$completed_requests = $completed_requests->fetchColumn();

// Recent requests
$stmt = $pdo->prepare("
    SELECT r.*, s.name AS site_name 
    FROM removal_requests r
    JOIN sites s ON r.site_id = s.id
    WHERE r.user_id = ?
    ORDER BY r.created_at DESC
    LIMIT 25
");
$stmt->execute([$user_id]);
$requests = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
    <title>My Dashboard</title>
    <link rel="stylesheet" href="/assets/css/style.css">
    <style>
        body { background:#020617; color:white; font-family:sans-serif; margin:0; }
        .user-shell { max-width:1100px; margin:0 auto; padding:2rem 1.5rem 3rem; }
        .user-header { display:flex; justify-content:space-between; align-items:center; margin-bottom:2rem; }
        .user-header h1 { font-size:1.8rem; margin:0; }
        .btn-primary { padding:.7rem 1rem; background:#0f172a; border:1px solid #334155; border-radius:.6rem; color:white; text-decoration:none; font-size:.95rem; }
        .btn-primary:hover { background:#1e293b; }
        .stats-grid { display:grid; grid-template-columns:repeat(auto-fit,minmax(200px,1fr)); gap:1rem; margin-bottom:2rem; }
        .stat-card { background:#020617; border:1px solid #1e293b; border-radius:1rem; padding:1.3rem 1.4rem; }
        .stat-label { font-size:.85rem; color:#9ca3af; }
        .stat-value { font-size:1.8rem; margin-top:.4rem; }
        .requests-card { background:#020617; border:1px solid #1e293b; border-radius:1rem; padding:1.2rem 1.4rem; }
        table { width:100%; border-collapse:collapse; margin-top:.5rem; }
        th, td { padding:.75rem .6rem; font-size:.9rem; border-bottom:1px solid #1e293b; text-align:left; }
        th { color:#9ca3af; font-weight:500; }
        .badge { display:inline-block; padding:.2rem .55rem; border-radius:999px; font-size:.75rem; }
        .badge-pending { background:#1f2937; color:#fde68a; }
        .badge-submitted { background:#1e293b; color:#bfdbfe; }
        .badge-in_review { background:#1e293b; color:#e5e7eb; }
        .badge-completed { background:#022c22; color:#6ee7b7; }
        .badge-rejected { background:#450a0a; color:#fecaca; }
        .empty { padding:1rem 0; color:#6b7280; }
        @media (max-width:700px){
            .user-header { flex-direction:column; align-items:flex-start; gap:.75rem; }
        }
    </style>
</head>
<body>
<div class="user-shell">
    <div class="user-header">
        <h1>Privacy Dashboard</h1>
        <a class="btn-primary" href="request_new.php">➕ New Removal Request</a>
    </div>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Total Requests</div>
            <div class="stat-value"><?= (int)$total_requests ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Active (Pending / In Progress)</div>
            <div class="stat-value"><?= (int)$pending_requests ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Completed</div>
            <div class="stat-value"><?= (int)$completed_requests ?></div>
        </div>
    </div>

    <div class="requests-card">
        <h2 style="margin:0 0 .5rem;">My Recent Requests</h2>
        <?php if(!$requests): ?>
            <div class="empty">You haven't submitted any removal requests yet.</div>
        <?php else: ?>
        <table>
            <tr>
                <th>Site</th>
                <th>Status</th>
                <th>Submitted</th>
                <th>Notes</th>
            </tr>
            <?php foreach($requests as $r): ?>
                <?php
                    $status = $r['status'];
                    $badgeClass = 'badge-'.$status;
                ?>
                <tr>
                    <td><?= htmlspecialchars($r['site_name']) ?></td>
                    <td><span class="badge <?= $badgeClass ?>"><?= ucfirst($status) ?></span></td>
                    <td><?= htmlspecialchars($r['created_at']) ?></td>
                    <td><?= $r['notes'] ? htmlspecialchars(mb_strimwidth($r['notes'],0,50,'…')) : '-' ?></td>
                </tr>
            <?php endforeach; ?>
        </table>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
