<?php
require_once __DIR__ . '/../../includes/auth.php';
require_admin();
require_once __DIR__ . '/../../includes/db.php';
$users = $pdo->query("SELECT * FROM users ORDER BY created_at DESC")->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
<title>Manage Users</title>
<link rel="stylesheet" href="https://data.myaihub.xyz/assets/css/style.css">
<style>
body{display:flex;background:#0f172a;color:white;margin:0;font-family:sans-serif}
.sidebar{width:240px;background:#1e293b;height:100vh;padding:1.5rem;position:fixed;left:0;top:0;border-right:1px solid #334155}
.sidebar a{display:block;padding:.8rem 1rem;background:#0f172a;margin-bottom:.5rem;border-radius:.5rem;border:1px solid #334155;color:white;text-decoration:none}
.sidebar a:hover{background:#1e293b}
.main{margin-left:260px;padding:2rem;width:100%}
table{width:100%;border-collapse:collapse;background:#1e293b;border:1px solid #334155;border-radius:.5rem}
th,td{padding:1rem;border-bottom:1px solid #334155;font-size:.95rem}
th{background:#0f172a}
</style>
</head>
<body>
<div class="sidebar">
<h2>Admin Panel</h2>
<a href="dashboard.php">📊 Dashboard</a>
<a href="users.php">👤 Manage Users</a>
<a href="sites.php">🌐 Manage Sites</a>
<a href="requests.php">📨 Manage Requests</a>
<a href="../logout.php">🚪 Logout</a>
</div>
<div class="main">
<h1>Manage Users</h1>
<table>
<tr><th>ID</th><th>Email</th><th>Role</th><th>Status</th><th>Created</th></tr>
<?php foreach($users as $u): ?>
<tr>
<td><?= $u['id'] ?></td>
<td><?= htmlspecialchars($u['email']) ?></td>
<td><?= $u['role'] ?></td>
<td><?= $u['is_active']?'Active':'Disabled' ?></td>
<td><?= $u['created_at'] ?></td>
</tr>
<?php endforeach; ?>
</table>
</div>
</body>
</html>
