<?php
require_once __DIR__ . '/../../includes/auth.php'; require_admin();
require_once __DIR__ . '/../../includes/db.php';
$sites = $pdo->query("SELECT * FROM sites ORDER BY name")->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
<title>Manage Sites</title>
<link rel="stylesheet" href="https://data.myaihub.xyz/assets/css/style.css">
<style>
body{display:flex;background:#0f172a;color:white;margin:0;font-family:sans-serif}
.sidebar{width:240px;background:#1e293b;height:100vh;padding:1.5rem;position:fixed;left:0;top:0;border-right:1px solid #334155}
.sidebar a{display:block;padding:.8rem 1rem;background:#0f172a;margin-bottom:.5rem;border-radius:.5rem;border:1px solid #334155;color:white;text-decoration:none}
.sidebar a:hover{background:#1e293b}
.main{margin-left:260px;padding:2rem;width:100%}
table{width:100%;border-collapse:collapse;background:#1e293b;border:1px solid #334155;border-radius:.5rem}
th,td{padding:1rem;border-bottom:1px solid #334155}
th{background:#0f172a}
.btn-new{display:inline-block;padding:10px 14px;background:#0f172a;border:1px solid #334155;border-radius:.5rem;color:white;text-decoration:none;margin-bottom:1rem}
.btn-new:hover{background:#1e293b}
</style>
</head>
<body>
<div class="sidebar">
<h2>Admin Panel</h2>
<a href="dashboard.php">📊 Dashboard</a>
<a href="users.php">👤 Manage Users</a>
<a href="sites.php">🌐 Manage Sites</a>
<a href="requests.php">📨 Manage Requests</a>
<a href="../logout.php">🚪 Logout</a>
</div>
<div class="main">
<h1>Manage Sites</h1>
<a class="btn-new" href="site_new.php">➕ Add New Site</a>
<table>
<tr><th>Name</th><th>URL</th><th>Actions</th></tr>
<?php foreach($sites as $s): ?>
<tr>
<td><?= htmlspecialchars($s['name']) ?></td>
<td><?= htmlspecialchars($s['url']) ?></td>
<td><a style="color:#38bdf8" href="site_edit.php?id=<?= $s['id'] ?>">Edit</a></td>
</tr>
<?php endforeach; ?>
</table>
</div>
</body>
</html>
