<?php
require_once __DIR__ . '/../../includes/auth.php'; require_admin();
require_once __DIR__ . '/../../includes/db.php';
$stmt=$pdo->query("SELECT r.*,u.email,s.name AS site_name FROM removal_requests r JOIN users u ON r.user_id=u.id JOIN sites s ON r.site_id=s.id ORDER BY r.created_at DESC");
$rows=$stmt->fetchAll();
?>
<!DOCTYPE html><html><head><title>Requests</title>
<link rel="stylesheet" href="https://data.myaihub.xyz/assets/css/style.css">
<style>
body{display:flex;background:#0f172a;color:white;font-family:sans-serif;margin:0}
.sidebar{width:240px;background:#1e293b;height:100vh;padding:1.5rem;position:fixed;left:0;top:0;border-right:1px solid #334155}
.sidebar a{display:block;padding:.8rem 1rem;background:#0f172a;margin-bottom:.5rem;border:1px solid #334155;border-radius:.5rem;color:white;text-decoration:none}
.sidebar a:hover{background:#1e293b}
.main{margin-left:260px;padding:2rem;width:100%}
table{width:100%;border-collapse:collapse;background:#1e293b;border:1px solid #334155;border-radius:.5rem}
th,td{padding:1rem;border-bottom:1px solid #334155}
th{background:#0f172a}
</style></head>
<body>
<div class="sidebar">
<h2>Admin Panel</h2>
<a href="dashboard.php">📊 Dashboard</a>
<a href="users.php">👤 Manage Users</a>
<a href="sites.php">🌐 Manage Sites</a>
<a href="requests.php">📨 Manage Requests</a>
<a href="../logout.php">🚪 Logout</a>
</div>
<div class="main"><h1>Requests</h1>
<table>
<tr><th>User</th><th>Site</th><th>Status</th><th>Date</th><th>Action</th></tr>
<?php foreach($rows as $r): ?>
<tr>
<td><?= htmlspecialchars($r['email']) ?></td>
<td><?= htmlspecialchars($r['site_name']) ?></td>
<td><?= ucfirst($r['status']) ?></td>
<td><?= $r['created_at'] ?></td>
<td><a style="color:#38bdf8" href="request_view.php?id=<?= $r['id'] ?>">View</a></td>
</tr>
<?php endforeach; ?>
</table>
</div>
</body></html>
