<?php
require_once __DIR__ . '/../../includes/auth.php';
require_admin();
require_once __DIR__ . '/../../includes/db.php';

$total_users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
$total_sites = $pdo->query("SELECT COUNT(*) FROM sites")->fetchColumn();
$total_requests = $pdo->query("SELECT COUNT(*) FROM removal_requests")->fetchColumn();
?>
<!DOCTYPE html>
<html>
<head>
<title>Admin Dashboard</title>
<link rel="stylesheet" href="https://data.myaihub.xyz/assets/css/style.css">
<style>
body { display:flex; background:#0f172a; color:white; font-family:sans-serif; margin:0; }
.sidebar { width:240px; background:#1e293b; height:100vh; padding:1.5rem; position:fixed; left:0; top:0; border-right:1px solid #334155; }
.sidebar a { display:block; padding:.8rem 1rem; background:#0f172a; margin-bottom:.5rem; border-radius:.5rem; border:1px solid #334155; color:white; text-decoration:none; }
.sidebar a:hover { background:#1e293b; }
.main { margin-left:260px; padding:2rem; width:100%; }
.stats-grid { display:grid; grid-template-columns:repeat(auto-fit,minmax(220px,1fr)); gap:1rem; margin-bottom:2rem; }
.stat-card { background:#1e293b; border:1px solid #334155; padding:1.5rem; border-radius:1rem; }
.stat-title { color:#94a3b8; }
.stat-value { font-size:2rem; }
.quick-grid { display:grid; gap:1rem; grid-template-columns:repeat(auto-fit,minmax(200px,1fr)); }
.quick-btn { background:#0f172a; border:1px solid #334155; padding:1rem; border-radius:.6rem; text-align:center; color:white; text-decoration:none; }
.quick-btn:hover { background:#1e293b; }
</style>
</head>
<body>
<div class="sidebar">
<h2>Admin Panel</h2>
<a href="dashboard.php">📊 Dashboard</a>
<a href="users.php">👤 Manage Users</a>
<a href="sites.php">🌐 Manage Sites</a>
<a href="requests.php">📨 Manage Requests</a>
<a href="../logout.php">🚪 Logout</a>
</div>
<div class="main">
<h1>Welcome, Admin</h1>
<div class="stats-grid">
<div class="stat-card"><div class="stat-title">Users</div><div class="stat-value"><?= $total_users ?></div></div>
<div class="stat-card"><div class="stat-title">Sites</div><div class="stat-value"><?= $total_sites ?></div></div>
<div class="stat-card"><div class="stat-title">Requests</div><div class="stat-value"><?= $total_requests ?></div></div>
</div>
<h2>Quick Actions</h2>
<div class="quick-grid">
<a class="quick-btn" href="users.php">Manage Users</a>
<a class="quick-btn" href="sites.php">Manage Sites</a>
<a class="quick-btn" href="requests.php">Manage Requests</a>
</div>
</div>
</body>
</html>
